<?php
// Test AI Generator
require_once 'vendor/autoload.php';

use App\Services\AITextGeneratorService;

$aiService = new AITextGeneratorService();

echo "🤖 Testing AI Generator - Text Expansion\n\n";

// Test 1: Expand "ringkas"
echo "Test 1: Expanding 'ringkas'\n";
echo "Input: ringkas\n";
$result1 = $aiService->expandText('ringkas', 'general');
echo "Success: " . ($result1['success'] ? 'YES' : 'NO') . "\n";
echo "Output: " . ($result1['text'] ?? 'No text') . "\n\n";

// Test 2: Expand "pembelajaran"
echo "Test 2: Expanding 'pembelajaran'\n";
echo "Input: pembelajaran\n";
$result2 = $aiService->expandText('pembelajaran', 'pelatihan');
echo "Success: " . ($result2['success'] ? 'YES' : 'NO') . "\n";
echo "Output: " . ($result2['text'] ?? 'No text') . "\n\n";

// Test 3: Expand "proyek web"
echo "Test 3: Expanding 'proyek web'\n";
echo "Input: proyek web\n";
$result3 = $aiService->expandText('proyek web', 'proyek');
echo "Success: " . ($result3['success'] ? 'YES' : 'NO') . "\n";
echo "Output: " . ($result3['text'] ?? 'No text') . "\n\n";

echo "✅ Test completed!\n";
?>